/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public class LevitateModifier
extends Modifier
implements ProjectileLaunchModifierHook,
ProjectileHitModifierHook {
    private static MobEffectInstance makeLevitateEffect(int level) {
        return new MobEffectInstance(MobEffects.f_19620_, 60 * level, level);
    }

    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, TinkerHooks.PROJECTILE_LAUNCH, TinkerHooks.PROJECTILE_HIT);
    }

    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        if (context.isFullyCharged()) {
            LivingEntity target = context.getLivingTarget();
            LivingEntity attacker = context.getAttacker();
            if (target != null && target.m_6084_()) {
                target.m_7292_(LevitateModifier.makeLevitateEffect(level));
                ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)(2 * level), (LivingEntity)attacker);
            }
        }
        return 0;
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        AbstractArrow arrow;
        if (target != null && (!(projectile instanceof AbstractArrow) || (arrow = (AbstractArrow)projectile).m_36792_())) {
            target.m_7292_(LevitateModifier.makeLevitateEffect(modifier.getLevel()));
        }
        return false;
    }

    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, NamespacedNBT persistentData, boolean primary) {
    }
}

